-- Use this to EASILY refer to colors and modify them instead of paste
-- them willy nilly in the theme itself. saves time, but decreases
-- readbility.

-- Uses the template:
-- Screen: Element,Element,Element

-- ScreenWithMenuElements: HeaderText,HeaderSubText

cRed = color("#ed1c24");
cOrange = color("#f7941d");
cYellow = color("#fff200");
cGreen = color("#39b54a");
cBlue = color("#00aeef");
cPurple = color("#cc33c7");
cWhite = color("#ffffff");
cBlack = color("#000000");

local ThemeColors = {
	Test1	=	color("#ffe100"),
	Test2 	= 	color("#f2ede7"),
	Test3 	=	color("#00aeef"),
	Test4 	=	color("#fee000"),
};

function ThemeColor(color)
	return ThemeColors[color]
end;

local PlayerColors = {
-- In The Groove
    PLAYER_1 = color("#FBBE03"),
    PLAYER_2 = color("#56FF48"),
};
local DifficultyColors = {
-- In The Groove
    Difficulty_Beginner = color("#E580FF"), -- Purple
    Difficulty_Easy = color("#00FF00"), -- Green
    Difficulty_Medium = color("#FFFF00"), -- Yellow
    Difficulty_Hard = color("#E52020"), -- Red
    Difficulty_Challenge = color("#329DD9"), -- Blue
    Difficulty_Edit = color("#CCCCCC"), -- Grey
};
function DifficultyColor( dc ) return DifficultyColors[dc] end

-- Might Not Be Needed!
local JudgeColors = {
    TapNoteScore_W1 = color("#FFFFCC"),   -- Marvelous / light goldish
    TapNoteScore_W2 = color("#FFDD00"),   -- Perfect / gold
    TapNoteScore_W3 = color("#00DD00"),   -- Great / green
    TapNoteScore_W4 = color("#00C0FF"),   -- Good / aj blue
    TapNoteScore_W5 = color("#CC00FF"),   -- Boo / purple
    TapNoteScore_Miss = color("#DB2122"), -- Miss / red
    HoldNoteScore_Held = color("#FFFFFF"),
    TapNoteScore_MaxCombo = color("#ffc600"), -- 
};

function LightColor(color)
    local c = color
    return { c[1]+(c[1]/2), c[2]+(c[2]/2), c[3]+(c[3]/2), c[4] };
end;

function DarkColor(color)
    local c = color
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;

function BoostColor(color,boost)
    local c = color
	return { c[1]*boost, c[2]*boost, c[3]*boost, c[4] };
end;

function JudgeColor(color)
    return JudgeColors[color]
end

function PlayerColor(pn)
    if pn == PLAYER_1 then return PlayerColors['PLAYER_1'] end
    if pn == PLAYER_2 then return PlayerColors['PLAYER_2'] end
    return color("1,1,1,1")
end;